<!DOCTYPE html>
<html class="no-js" lang="">

<head>
    <meta http-equiv="content-type" content="text/html;charset=utf-8">


    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>NextEdge CRM</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">


    <link rel="stylesheet" type="text/css" href="https://cdn.plyr.io/3.5.6/plyr.css" media="all">
    <link rel="stylesheet" href="assets/css/vendor.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <style id="vvvebjs-styles"></style>
</head>

<body class="">
    <div hidden="" id="sprite-plyr"><!--?xml version="1.0" encoding="UTF-8"?--><svg xmlns="http://www.w3.org/2000/svg"
            xmlns:xlink="http://www.w3.org/1999/xlink">
            <symbol id="plyr-airplay">
                <path d="M16 1H2a1 1 0 0 0-1 1v10a1 1 0 0 0 1 1h3v-2H3V3h12v8h-2v2h3a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1z">
                </path>
                <path d="M4 17h10l-5-6z"></path>
            </symbol>
            <symbol id="plyr-captions-off">
                <path
                    d="M1 1c-.6 0-1 .4-1 1v11c0 .6.4 1 1 1h4.6l2.7 2.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3l2.7-2.7H17c.6 0 1-.4 1-1V2c0-.6-.4-1-1-1H1zm4.52 10.15c1.99 0 3.01-1.32 3.28-2.41l-1.29-.39c-.19.66-.78 1.45-1.99 1.45-1.14 0-2.2-.83-2.2-2.34 0-1.61 1.12-2.37 2.18-2.37 1.23 0 1.78.75 1.95 1.43l1.3-.41C8.47 4.96 7.46 3.76 5.5 3.76c-1.9 0-3.61 1.44-3.61 3.7 0 2.26 1.65 3.69 3.63 3.69zm7.57 0c1.99 0 3.01-1.32 3.28-2.41l-1.29-.39c-.19.66-.78 1.45-1.99 1.45-1.14 0-2.2-.83-2.2-2.34 0-1.61 1.12-2.37 2.18-2.37 1.23 0 1.78.75 1.95 1.43l1.3-.41c-.28-1.15-1.29-2.35-3.25-2.35-1.9 0-3.61 1.44-3.61 3.7 0 2.26 1.65 3.69 3.63 3.69z"
                    fill-rule="evenodd" fill-opacity=".5"></path>
            </symbol>
            <symbol id="plyr-captions-on">
                <path
                    d="M1 1c-.6 0-1 .4-1 1v11c0 .6.4 1 1 1h4.6l2.7 2.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3l2.7-2.7H17c.6 0 1-.4 1-1V2c0-.6-.4-1-1-1H1zm4.52 10.15c1.99 0 3.01-1.32 3.28-2.41l-1.29-.39c-.19.66-.78 1.45-1.99 1.45-1.14 0-2.2-.83-2.2-2.34 0-1.61 1.12-2.37 2.18-2.37 1.23 0 1.78.75 1.95 1.43l1.3-.41C8.47 4.96 7.46 3.76 5.5 3.76c-1.9 0-3.61 1.44-3.61 3.7 0 2.26 1.65 3.69 3.63 3.69zm7.57 0c1.99 0 3.01-1.32 3.28-2.41l-1.29-.39c-.19.66-.78 1.45-1.99 1.45-1.14 0-2.2-.83-2.2-2.34 0-1.61 1.12-2.37 2.18-2.37 1.23 0 1.78.75 1.95 1.43l1.3-.41c-.28-1.15-1.29-2.35-3.25-2.35-1.9 0-3.61 1.44-3.61 3.7 0 2.26 1.65 3.69 3.63 3.69z"
                    fill-rule="evenodd"></path>
            </symbol>
            <symbol id="plyr-download">
                <path
                    d="M9 13c.3 0 .5-.1.7-.3L15.4 7 14 5.6l-4 4V1H8v8.6l-4-4L2.6 7l5.7 5.7c.2.2.4.3.7.3zm-7 2h14v2H2z">
                </path>
            </symbol>
            <symbol id="plyr-enter-fullscreen">
                <path d="M10 3h3.6l-4 4L11 8.4l4-4V8h2V1h-7zM7 9.6l-4 4V10H1v7h7v-2H4.4l4-4z"></path>
            </symbol>
            <symbol id="plyr-exit-fullscreen">
                <path d="M1 12h3.6l-4 4L2 17.4l4-4V17h2v-7H1zM16 .6l-4 4V1h-2v7h7V6h-3.6l4-4z"></path>
            </symbol>
            <symbol id="plyr-fast-forward">
                <path d="M7.875 7.171L0 1v16l7.875-6.171V17L18 9 7.875 1z"></path>
            </symbol>
            <symbol id="plyr-logo-vimeo">
                <path
                    d="M17 5.3c-.1 1.6-1.2 3.7-3.3 6.4-2.2 2.8-4 4.2-5.5 4.2-.9 0-1.7-.9-2.4-2.6C5 10.9 4.4 6 3 6c-.1 0-.5.3-1.2.8l-.8-1c.8-.7 3.5-3.4 4.7-3.5 1.2-.1 2 .7 2.3 2.5.3 2 .8 6.1 1.8 6.1.9 0 2.5-3.4 2.6-4 .1-.9-.3-1.9-2.3-1.1.8-2.6 2.3-3.8 4.5-3.8 1.7.1 2.5 1.2 2.4 3.3z">
                </path>
            </symbol>
            <symbol id="plyr-logo-youtube">
                <path
                    d="M16.8 5.8c-.2-1.3-.8-2.2-2.2-2.4C12.4 3 9 3 9 3s-3.4 0-5.6.4C2 3.6 1.3 4.5 1.2 5.8 1 7.1 1 9 1 9s0 1.9.2 3.2c.2 1.3.8 2.2 2.2 2.4C5.6 15 9 15 9 15s3.4 0 5.6-.4c1.4-.3 2-1.1 2.2-2.4.2-1.3.2-3.2.2-3.2s0-1.9-.2-3.2zM7 12V6l5 3-5 3z">
                </path>
            </symbol>
            <symbol id="plyr-muted">
                <path
                    d="M12.4 12.5l2.1-2.1 2.1 2.1 1.4-1.4L15.9 9 18 6.9l-1.4-1.4-2.1 2.1-2.1-2.1L11 6.9 13.1 9 11 11.1zM3.786 6.008H.714C.286 6.008 0 6.31 0 6.76v4.512c0 .452.286.752.714.752h3.072l4.071 3.858c.5.3 1.143 0 1.143-.602V2.752c0-.601-.643-.977-1.143-.601L3.786 6.008z">
                </path>
            </symbol>
            <symbol id="plyr-pause">
                <path
                    d="M6 1H3c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h3c.6 0 1-.4 1-1V2c0-.6-.4-1-1-1zm6 0c-.6 0-1 .4-1 1v14c0 .6.4 1 1 1h3c.6 0 1-.4 1-1V2c0-.6-.4-1-1-1h-3z">
                </path>
            </symbol>
            <symbol id="plyr-pip">
                <path d="M13.293 3.293L7.022 9.564l1.414 1.414 6.271-6.271L17 7V1h-6z"></path>
                <path d="M13 15H3V5h5V3H2a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-6h-2v5z"></path>
            </symbol>
            <symbol id="plyr-play">
                <path
                    d="M15.562 8.1L3.87.225c-.818-.562-1.87 0-1.87.9v15.75c0 .9 1.052 1.462 1.87.9L15.563 9.9c.584-.45.584-1.35 0-1.8z">
                </path>
            </symbol>
            <symbol id="plyr-restart">
                <path
                    d="M9.7 1.2l.7 6.4 2.1-2.1c1.9 1.9 1.9 5.1 0 7-.9 1-2.2 1.5-3.5 1.5-1.3 0-2.6-.5-3.5-1.5-1.9-1.9-1.9-5.1 0-7 .6-.6 1.4-1.1 2.3-1.3l-.6-1.9C6 2.6 4.9 3.2 4 4.1 1.3 6.8 1.3 11.2 4 14c1.3 1.3 3.1 2 4.9 2 1.9 0 3.6-.7 4.9-2 2.7-2.7 2.7-7.1 0-9.9L16 1.9l-6.3-.7z">
                </path>
            </symbol>
            <symbol id="plyr-rewind">
                <path d="M10.125 1L0 9l10.125 8v-6.171L18 17V1l-7.875 6.171z"></path>
            </symbol>
            <symbol id="plyr-settings">
                <path
                    d="M16.135 7.784a2 2 0 0 1-1.23-2.969c.322-.536.225-.998-.094-1.316l-.31-.31c-.318-.318-.78-.415-1.316-.094a2 2 0 0 1-2.969-1.23C10.065 1.258 9.669 1 9.219 1h-.438c-.45 0-.845.258-.997.865a2 2 0 0 1-2.969 1.23c-.536-.322-.999-.225-1.317.093l-.31.31c-.318.318-.415.781-.093 1.317a2 2 0 0 1-1.23 2.969C1.26 7.935 1 8.33 1 8.781v.438c0 .45.258.845.865.997a2 2 0 0 1 1.23 2.969c-.322.536-.225.998.094 1.316l.31.31c.319.319.782.415 1.316.094a2 2 0 0 1 2.969 1.23c.151.607.547.865.997.865h.438c.45 0 .845-.258.997-.865a2 2 0 0 1 2.969-1.23c.535.321.997.225 1.316-.094l.31-.31c.318-.318.415-.781.094-1.316a2 2 0 0 1 1.23-2.969c.607-.151.865-.547.865-.997v-.438c0-.451-.26-.846-.865-.997zM9 12a3 3 0 1 1 0-6 3 3 0 0 1 0 6z">
                </path>
            </symbol>
            <symbol id="plyr-volume">
                <path
                    d="M15.6 3.3c-.4-.4-1-.4-1.4 0-.4.4-.4 1 0 1.4C15.4 5.9 16 7.4 16 9c0 1.6-.6 3.1-1.8 4.3-.4.4-.4 1 0 1.4.2.2.5.3.7.3.3 0 .5-.1.7-.3C17.1 13.2 18 11.2 18 9s-.9-4.2-2.4-5.7z">
                </path>
                <path
                    d="M11.282 5.282a.909.909 0 0 0 0 1.316c.735.735.995 1.458.995 2.402 0 .936-.425 1.917-.995 2.487a.909.909 0 0 0 0 1.316c.145.145.636.262 1.018.156a.725.725 0 0 0 .298-.156C13.773 11.733 14.13 10.16 14.13 9c0-.17-.002-.34-.011-.51-.053-.992-.319-2.005-1.522-3.208a.909.909 0 0 0-1.316 0zm-7.496.726H.714C.286 6.008 0 6.31 0 6.76v4.512c0 .452.286.752.714.752h3.072l4.071 3.858c.5.3 1.143 0 1.143-.602V2.752c0-.601-.643-.977-1.143-.601L3.786 6.008z">
                </path>
            </symbol>
        </svg></div>
    <div class="preloader" style="opacity: 0; display: none;">
        <div class="loader">
            <div class="spinner">
                <div class="spinner-container">
                    <div class="spinner-rotator">
                        <div class="spinner-left">
                            <div class="spinner-circle"></div>
                        </div>
                        <div class="spinner-right">
                            <div class="spinner-circle"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <section id="home" class="hero-section-wrapper-2">

        <header class="header header-2 sticky">
            <div class="navbar-area">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-12">
                            <nav class="navbar navbar-expand-lg">
                                <a class="navbar-brand" href="/">
                                    <img src="assets/img/logo/logo.svg" alt="Logo">
                                </a>
                                <button class="navbar-toggler" type="button" data-toggle="collapse"
                                    data-target="#navbarSupportedContent2" aria-controls="navbarSupportedContent2"
                                    aria-expanded="false" aria-label="Toggle navigation">
                                    <span class="toggler-icon"></span>
                                    <span class="toggler-icon"></span>
                                    <span class="toggler-icon"></span>
                                </button>
                                <div class="collapse navbar-collapse sub-menu-bar" id="navbarSupportedContent2">
                                    <ul id="nav2" class="navbar-nav ml-auto">
                                        <li class="nav-item">
                                            <a class="page-scroll" href="#home">Home</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="page-scroll" href="#services">Services</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="page-scroll" href="#about">About</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="page-scroll" href="#portfolio">Portfolio</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="page-scroll" href="#pricing">Pricing</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="page-scroll" href="#contact">Contact</a>
                                        </li>
                                    </ul>
                                    <a href="#0" class="button button-sm radius-10 d-none d-lg-flex">Get Started</a>
                                </div>

                            </nav>

                        </div>
                    </div>

                </div>

            </div>

        </header>


        <div class="hero-section hero-style-2">
            <div class="container">
                <div class="row align-items-end">
                    <div class="col-lg-6">
                        <div class="hero-content-wrapper">
                            <h4 class="wow fadeInUp" data-wow-delay=".2s"
                                style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">AI Driven
                                Modern CRM</h4>
                            <h2 class="mb-30 wow fadeInUp" data-wow-delay=".4s"
                                style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">Discover
                                the Power of Our CRM Solution</h2>
                            <p class="mb-50 wow fadeInUp" data-wow-delay=".6s"
                                style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">Are you
                                struggling to manage customer relationships effectively? Do you
                                find it challenging to keep track of important leads, organize customer
                                data, and streamline your sales process? Look no further.</p>
                            <div class="buttons">
                                <a href="#pricing" class="button button-lg radius-10 wow fadeInUp" data-wow-delay=".7s"
                                    style="visibility: visible; animation-delay: 0.7s; animation-name: fadeInUp;">Free
                                    30 days Trial</a>
                                <a href="#" class="video-button glightbox wow fadeInUp" data-wow-delay=".8s"
                                    style="visibility: visible; animation-delay: 0.8s; animation-name: fadeInUp;"> <span
                                        class="icon"><i class="lni lni-play"></i></span> <span>Watch now</span> </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="hero-image">
                            <img src="assets/img/hero/hero-2/hero-img.svg" alt="" class="wow fadeInRight"
                                data-wow-delay=".2s"
                                style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInRight;">
                            <img src="assets/img/hero/hero-2/paattern.svg" alt="" class="shape shape-1">
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>


    <section id="services" class="feature-section feature-style-2">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="row">
                        <div class="col-xl-7 col-lg-10 col-md-9">
                            <div class="section-title mb-60">
                                <h3 class="mb-15 wow fadeInUp" data-wow-delay=".2s"
                                    style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">The
                                    future of smart AI CRM starts here
                                </h3>
                                <p class="wow fadeInUp" data-wow-delay=".4s"
                                    style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">Stop
                                    wasting time and money designing and
                                    managing a CRM solution that doesn’t get results. Happiness guaranteed!</p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="single-feature wow fadeInUp" data-wow-delay=".2s"
                                style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                                <div class="icon">
                                    <i class="lni lni-vector"></i>
                                </div>
                                <div class="content">
                                    <h5 class="mb-25">Easy Integration</h5>
                                    <p>Data-driven decision making is essential for growth.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="single-feature wow fadeInUp" data-wow-delay=".4s"
                                style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                                <div class="icon">
                                    <i class="lni lni-layers"></i>
                                </div>
                                <div class="content">
                                    <h5 class="mb-25">AI Tools</h5>
                                    <p>Data-driven decision making is essential for growth</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="single-feature wow fadeInUp" data-wow-delay=".6s"
                                style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                                <div class="icon">
                                    <i class="lni lni-layout"></i>
                                </div>
                                <div class="content">
                                    <h5 class="mb-25">Moder Design</h5>
                                    <p>Data-driven decision making is essential for growth</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="single-feature wow fadeInUp" data-wow-delay=".8s"
                                style="visibility: visible; animation-delay: 0.8s; animation-name: fadeInUp;">
                                <div class="icon">
                                    <i class="lni lni-display"></i>
                                </div>
                                <div class="content">
                                    <h5 class="mb-25">24/7 Support</h5>
                                    <p>Data-driven decision making is essential for growth</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="feature-img wow fadeInLeft" data-wow-delay=".2s"
            style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInLeft;">
            <img src="assets/img/feature/feature-2-1.svg" alt="">
        </div>
    </section>


    <section id="about" class="about-section about-style-3">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="about-image wow fadeInLeft" data-wow-delay=".2s"
                        style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInLeft;">
                        <img src="assets/img/about/about-3/xabout-img.jpg.pagespeed.ic.r1NwehGahh.jpg" alt="">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="about-content-wrapper">
                        <div class="section-title mb-40">
                            <h3 class="mb-25 wow fadeInUp" data-wow-delay=".2s"
                                style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">The future
                                of AI CRX starts here</h3>
                            <p class="wow fadeInUp" data-wow-delay=".4s"
                                style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">Make
                                informed decisions and drive business growth with our CRM's
                                advanced reporting and analytics. Gain valuable insights into customer
                                behavior, sales performance, and marketing campaigns. Leverage this data
                                to identify trends, optimize your strategies, and capitalize on new
                                opportunities.</p>
                        </div>
                        <div class="counter-up-wrapper mb-40 wow fadeInUp" data-wow-delay=".6s"
                            style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                            <div class="single-counter">
                                <h4 class="countup" id="secondo1" cup-end="123" cup-append="M">123M</h4>
                                <h6>Happy Client</h6>
                            </div>
                            <div class="single-counter">
                                <h4 class="countup" id="secondo2" cup-end="1434" cup-append="K">1434K</h4>
                                <h6>Businesses</h6>
                            </div>
                            <div class="single-counter">
                                <h4 class="countup" id="secondo3" cup-end="134" cup-append="K">134K</h4>
                                <h6>Award Win</h6>
                            </div>
                        </div>
                        <a href="#0" class="button button-lg radius-3 wow fadeInUp" data-wow-delay=".7s"
                            style="visibility: visible; animation-delay: 0.7s; animation-name: fadeInUp;">Learn More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section id="portfolio" class="gallery-section gallery-style-1">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-5 col-lg-7 col-md-10">
                    <div class="section-title text-center mb-60">
                        <h3 class="mb-15 wow fadeInUp" data-wow-delay=".2s"
                            style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">Our CRX
                            Gallery</h3>
                        <p class="wow fadeInUp" data-wow-delay=".4s"
                            style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">Stop wasting
                            time and money designing and managing
                            a website that doesn’t get results. Happiness guaranteed!</p>
                    </div>
                </div>
            </div>
            <div class="row grid" style="position: relative; height: 651.984px;">
                <div class="col-lg-4 col-md-6 grid-item" style="position: absolute; left: 0px; top: 0px;">
                    <div class="single-gallery wow fadeInUp" data-wow-delay=".2s"
                        style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/gallery/gallery-1/xgallery-1.jpg.pagespeed.ic.T5DmllFYTl.jpg" alt="">
                        </div>
                        <div class="overlay">
                            <div class="overlay-content">
                                <div class="action">
                                    <a href="#0"> <i class="lni lni-link"></i> </a>
                                </div>
                                <div class="info">
                                    <h5>Marketing</h5>
                                    <p>Deliver exceptional customer experiences by leveraging our CRM's features</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grid-item" style="position: absolute; left: 319.992px; top: 0px;">
                    <div class="single-gallery wow fadeInUp" data-wow-delay=".4s"
                        style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/gallery/gallery-1/xgallery-2.jpg.pagespeed.ic.hXIN61UH-T.jpg" alt="">
                        </div>
                        <div class="overlay">
                            <div class="overlay-content">
                                <div class="action">
                                    <a href="#0"> <i class="lni lni-link"></i> </a>
                                </div>
                                <div class="info">
                                    <h5>AI Tools</h5>
                                    <p>Deliver exceptional customer experiences by leveraging our CRM's features</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grid-item" style="position: absolute; left: 639.984px; top: 0px;">
                    <div class="single-gallery wow fadeInUp" data-wow-delay=".6s"
                        style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/gallery/gallery-1/gallery-3.jpg" alt="">
                        </div>
                        <div class="overlay">
                            <div class="overlay-content">
                                <div class="action">
                                    <a href="#0"> <i class="lni lni-link"></i> </a>
                                </div>
                                <div class="info">
                                    <h5>Marketing</h5>
                                    <p>Deliver exceptional customer experiences by leveraging our CRM's features</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grid-item" style="position: absolute; left: 639.984px; top: 293.102px;">
                    <div class="single-gallery wow fadeInUp" data-wow-delay=".2s"
                        style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/gallery/gallery-1/xgallery-6.jpg.pagespeed.ic.LCvJzT3VDp.jpg" alt="">
                        </div>
                        <div class="overlay">
                            <div class="overlay-content">
                                <div class="action">
                                    <a href="#0"> <i class="lni lni-link"></i> </a>
                                </div>
                                <div class="info">
                                    <h5>AI Tools</h5>
                                    <p>Deliver exceptional customer experiences by leveraging our CRM's features</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grid-item" style="position: absolute; left: 0px; top: 325.992px;">
                    <div class="single-gallery wow fadeInUp" data-wow-delay=".4s"
                        style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/gallery/gallery-1/gallery-4.jpg" alt="">
                        </div>
                        <div class="overlay">
                            <div class="overlay-content">
                                <div class="action">
                                    <a href="#0"> <i class="lni lni-link"></i> </a>
                                </div>
                                <div class="info">
                                    <h5>Modern Design</h5>
                                    <p>Deliver exceptional customer experiences by leveraging our CRM's features</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 grid-item" style="position: absolute; left: 319.992px; top: 409.852px;">
                    <div class="single-gallery wow fadeInUp" data-wow-delay=".6s"
                        style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/gallery/gallery-1/gallery-5.jpg" alt="">
                        </div>
                        <div class="overlay">
                            <div class="overlay-content">
                                <div class="action">
                                    <a href="#0"> <i class="lni lni-link"></i> </a>
                                </div>
                                <div class="info">
                                    <h5>Marketing</h5>
                                    <p>Deliver exceptional customer experiences by leveraging our CRM's features</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section id="pricing" class="pricing-section pricing-style-1 bg-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-5 col-lg-7 col-md-10">
                    <div class="section-title text-center mb-60">
                        <h3 class="mb-15 wow fadeInUp" data-wow-delay=".2s"
                            style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">Pricing Plan
                        </h3>
                        <p class="wow fadeInUp" data-wow-delay=".4s"
                            style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;"><span
                                style="color: rgba(0, 0, 0, 0.7); font-family: Sen, sans-serif;">Flexible and Affordable
                                Pricing to Meet Your Business Needs. Either Agency or Individual, we got you covered
                                !</span></p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-lg-4 col-md-8 col-sm-10">
                    <div class="single-pricing wow fadeInUp" data-wow-delay=".2s"
                        style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/pricing/pricing-1/pricing-1.svg" alt="">
                        </div>
                        <h6>Basic</h6>
                        <h4>Freelancer</h4>
                        <h3>$ 29.00</h3>
                        <ul>
                            <li> <i class="lni lni-checkmark-circle"></i> Shared Database</li>
                            <li> <i class="lni lni-checkmark-circle"></i> 20 Users</li>
                            <li> <i class="lni lni-checkmark-circle"></i> Unlimited Invoice/Leads</li>
                            <li> <i class="lni lni-checkmark-circle"><span
                                        style="color: rgb(88, 89, 120); font-family: Heebo, sans-serif;">&nbsp; Awesome
                                        Support</span></i></li>
                        </ul>
                        <a href="#pricing" class="button radius-30">Get Started</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-8 col-sm-10">
                    <div class="single-pricing active wow fadeInUp" data-wow-delay=".4s"
                        style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                        <span class="button button-sm radius-30 popular-badge">Popular</span>
                        <div class="image">
                            <img src="assets/img/pricing/pricing-1/pricing-2.svg" alt="">
                        </div>
                        <h6>Standard</h6>
                        <h4>Large company</h4>
                        <h3>$ 89.00</h3>
                        <ul>
                            <li> <i class="lni lni-checkmark-circle"></i> Single Database</li>
                            <li> <i class="lni lni-checkmark-circle"></i> 500+ Users</li>
                            <li> <i class="lni lni-checkmark-circle"></i> Unlimited Invoice and Leads</li>
                            <li> <i class="lni lni-checkmark-circle"></i> Awesome Support</li>
                        </ul>
                        <a href="#pricing" class="button radius-30">Get Started</a>
                    </div>
                </div>
                <div class="col-lg-4 col-md-8 col-sm-10">
                    <div class="single-pricing wow fadeInUp" data-wow-delay=".6s"
                        style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/pricing/pricing-1/pricing-3.svg" alt="">
                        </div>
                        <h6>Pro</h6>
                        <h4>Agency</h4>
                        <h3>$ 199.00</h3>
                        <ul>
                            <li> <i class="lni lni-checkmark-circle"></i> Single Cloud Database</li>
                            <li> <i class="lni lni-checkmark-circle"></i> Unlimited Users</li>
                            <li> <i class="lni lni-checkmark-circle"></i> Unlimited Invoices and Leads</li>
                            <li> <i class="lni lni-checkmark-circle"></i> Awesome Support</li>
                        </ul>
                        <a href="#pricing" class="button radius-30">Get Started</a>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section id="team" class="team-section team-style-1">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-xl-5 col-lg-7 col-md-10">
                    <div class="section-title text-center mb-60">
                        <h3 class="mb-15 wow fadeInUp" data-wow-delay=".2s"
                            style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">Our Team</h3>
                        <p class="wow fadeInUp" data-wow-delay=".4s"
                            style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">Stop wasting
                            time and money designing and managing
                            a website that doesn’t get results. Happiness guaranteed!</p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-xl-3 col-md-6 col-sm-10">
                    <div class="single-team wow fadeInUp" data-wow-delay=".2s"
                        style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/team/team-1/team-1.png" alt="">
                        </div>
                        <div class="info">
                            <h6>John Doe</h6>
                            <p>Product Designer</p>
                            <ul class="socials">
                                <li>
                                    <a href="#0"> <i class="lni lni-facebook-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-twitter-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-instagram-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-linkedin-original"></i> </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-sm-10">
                    <div class="single-team wow fadeInUp" data-wow-delay=".4s"
                        style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/team/team-1/team-2.png" alt="">
                        </div>
                        <div class="info">
                            <h6>David Endow</h6>
                            <p>Creative Designer</p>
                            <ul class="socials">
                                <li>
                                    <a href="#0"> <i class="lni lni-facebook-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-twitter-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-instagram-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-linkedin-original"></i> </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-sm-10">
                    <div class="single-team wow fadeInUp" data-wow-delay=".6s"
                        style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/team/team-1/team-3.png" alt="">
                        </div>
                        <div class="info">
                            <h6>Jonathon Smith</h6>
                            <p>Brand Designer</p>
                            <ul class="socials">
                                <li>
                                    <a href="#0"> <i class="lni lni-facebook-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-twitter-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-instagram-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-linkedin-original"></i> </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-6 col-sm-10">
                    <div class="single-team wow fadeInUp" data-wow-delay=".8s"
                        style="visibility: visible; animation-delay: 0.8s; animation-name: fadeInUp;">
                        <div class="image">
                            <img src="assets/img/team/team-1/team-4.png" alt="">
                        </div>
                        <div class="info">
                            <h6>Gray Simon</h6>
                            <p>Frontend Developer</p>
                            <ul class="socials">
                                <li>
                                    <a href="#0"> <i class="lni lni-facebook-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-twitter-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-instagram-filled"></i> </a>
                                </li>
                                <li>
                                    <a href="#0"> <i class="lni lni-linkedin-original"></i> </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section id="testimonial" class="testimonial-section testimonial-style-1">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title text-center mb-60">
                        <h3 class="wow fadeInUp" data-wow-delay=".2s"
                            style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">Clients
                            Testimonial</h3>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-xl-4 col-md-6">
                    <div class="single-testimonial">
                        <div class="content-wrapper">
                            <div class="content">
                                <p>Since implementing their CRM solution, we have seen a remarkable
                                    improvement in our team's collaboration and productivity. The software's
                                    intuitive interface and seamless integration with other tools have made
                                    our daily operations much more efficient.</p>
                                <div class="quote">
                                    <i class="lni lni-quotation"></i>
                                </div>
                            </div>
                            <div class="info">
                                <div class="image">
                                    <img src="assets/img/testimonial/testimonial-1/testimonial-1.png" alt="">
                                </div>
                                <div class="text">
                                    <h5>John Doe</h5>
                                    <p>Youtuber</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6">
                    <div class="single-testimonial">
                        <div class="content-wrapper">
                            <div class="content">
                                <p>I have been using their CRM software for over a year now, and I am
                                    thrilled with the results. It has completely transformed the way we
                                    manage our customer relationships.</p>
                                <div class="quote">
                                    <i class="lni lni-quotation"></i>
                                </div>
                            </div>
                            <div class="info">
                                <div class="image">
                                    <img src="assets/img/testimonial/testimonial-1/testimonial-2.png" alt="">
                                </div>
                                <div class="text">
                                    <h5>David Smith</h5>
                                    <p>Traveler</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6">
                    <div class="single-testimonial">
                        <div class="content-wrapper">
                            <div class="content">
                                <p>Choosing their CRM software was one of the best decisions we made for
                                    our business. The comprehensive reporting and analytics features have
                                    given us valuable insights into our customers' preferences, helping us
                                    tailor our offerings and improve customer satisfaction.</p>
                                <div class="quote">
                                    <i class="lni lni-quotation"></i>
                                </div>
                            </div>
                            <div class="info">
                                <div class="image">
                                    <img src="assets/img/testimonial/testimonial-1/xtestimonial-3.png.pagespeed.ic.7Spef9SAFR.png"
                                        alt="">
                                </div>
                                <div class="text">
                                    <h5>Jonathan Doe</h5>
                                    <p>Vloger</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section id="contact" class="contact-section contact-style-6">
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="contact-form-wrapper">
                        <form method="post" action="/">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="single-input">
                                        <label for="name">Name</label>
                                        <input type="text" id="name" name="name" class="form-input" placeholder="Name">
                                        <i class="lni lni-user"></i>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="single-input">
                                        <label for="email">Email</label>
                                        <input type="email" id="email" name="email" class="form-input"
                                            placeholder="Email">
                                        <i class="lni lni-envelope"></i>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="single-input">
                                        <label for="number">Number</label>
                                        <input type="text" id="number" name="number" class="form-input"
                                            placeholder="Number">
                                        <i class="lni lni-phone"></i>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="single-input">
                                        <label for="subject">Subject</label>
                                        <input type="text" id="subject" name="subject" class="form-input"
                                            placeholder="Subject">
                                        <i class="lni lni-text-format"></i>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="single-input">
                                        <label for="message">Message</label>
                                        <textarea name="message" id="message" class="form-input" placeholder="Message"
                                            rows="6"></textarea>
                                        <i class="lni lni-comments-alt"></i>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-button">
                                        <button type="submit" class="button radius-10">Submit <i
                                                class="lni lni-telegram-original"></i> </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-5 order-first order-lg-last">
                    <div class="left-wrapper">
                        <div class="section-title mb-40">
                            <h3 class="mb-15">Get in touch</h3>
                            <p>Stop wasting time and money designing and managing a website that doesn’t get results.
                                Happiness guaranteed!</p>
                        </div>
                        <div class="row">
                            <div class="col-lg-12 col-md-6">
                                <div class="single-item">
                                    <div class="icon">
                                        <i class="lni lni-phone"></i>
                                    </div>
                                    <div class="text">
                                        <p>0045939863784</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-6">
                                <div class="single-item">
                                    <div class="icon">
                                        <i class="lni lni-envelope"></i>
                                    </div>
                                    <div class="text">
                                        <p><a href="mailto:support@perfextosaas.com" class="__cf_email__"
                                                data-cfemail="a0d9cfd5d2cdc1c9cce0c7cdc1c9cc8ec3cfcd">support@perfextosaas.com</a>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-6">
                                <div class="single-item">
                                    <div class="icon">
                                        <i class="lni lni-map-marker"></i>
                                    </div>
                                    <div class="text">
                                        <p>John's House, 13/5 Road, Sidny United State Of America</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="clients-logo-section pt-100 pb-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="client-logo wow fadeInUp" data-wow-delay=".2s"
                        style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                        <img src="assets/img/clients/brands.svg" alt="" class="w-100">
                    </div>
                </div>
            </div>
        </div>
    </section>


    <footer class="footer footer-style-1">
        <div class="container">
            <div class="widget-wrapper">
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="footer-widget wow fadeInUp" data-wow-delay=".2s"
                            style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                            <div class="logo">
                                <a href="#0"> <img src="assets/img/logo/logo.svg" alt=""> </a>
                            </div>
                            <p class="desc">Collaboration is key to success in any business. Our CRM software
                                promotes teamwork and transparency by enabling seamless collaboration
                                across departments.</p>
                            <ul class="socials">
                                <li> <a href="#0"> <i class="lni lni-facebook-filled"></i> </a> </li>
                                <li> <a href="#0"> <i class="lni lni-twitter-filled"></i> </a> </li>
                                <li> <a href="#0"> <i class="lni lni-instagram-filled"></i> </a> </li>
                                <li> <a href="#0"> <i class="lni lni-linkedin-original"></i> </a> </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-2 offset-xl-1 col-lg-2 col-md-6 col-sm-6">
                        <div class="footer-widget wow fadeInUp" data-wow-delay=".3s"
                            style="visibility: visible; animation-delay: 0.3s; animation-name: fadeInUp;">
                            <h6>Quick Link</h6>
                            <ul class="links">
                                <li> <a href="#0">Home</a> </li>
                                <li> <a href="#0">About</a> </li>
                                <li> <a href="#0">Service</a> </li>
                                <li> <a href="#0">Contact</a> </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                        <div class="footer-widget wow fadeInUp" data-wow-delay=".4s"
                            style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                            <h6>Services</h6>
                            <ul class="links">
                                <li> <a href="#0">Web Design</a> </li>
                                <li> <a href="#0">Web Development</a> </li>
                                <li> <a href="#0">Seo Optimization</a> </li>
                                <li> <a href="#0">Blog Writing</a> </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-3 col-md-6">
                        <div class="footer-widget wow fadeInUp" data-wow-delay=".5s"
                            style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                            <h6>Help &amp; Support</h6>
                            <ul class="links">
                                <li> <a href="#0">Support Center</a> </li>
                                <li> <a href="#0">Live Chat</a> </li>
                                <li> <a href="#0">FAQ</a> </li>
                                <li> <a href="#0">Terms &amp; Conditions</a> </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="copyright-wrapper wow fadeInUp" data-wow-delay=".2s"
                style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                <p>Design and Developed by <a href="#pricing" rel="nofollow" target="_blank">UIdeck</a> Built-with <a
                        href="#">Lindy UI Kit</a></p>
            </div>
        </div>
    </footer>


    <a href="#" class="scroll-top" style="display: flex;"> <i class="lni lni-chevron-up"></i> </a>


    <script src="assets/js/vendor.js"></script>
    <script src="assets/js/main.js"></script>
    <script type="text/javascript" src="https://cdn.plyr.io/3.5.6/plyr.js"></script>

</body>

</html>